/* pools worker level data across all 3 waves; input datasets
taken from worker1.sas for Wave 1 and workmerge.sas for Waves 
2 and 3. Then runs series of earnings functions and descriptive
statistics on the pooled data file cd.cd.work123 */

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';



data worker1; set cd.work1;

wid1=wid;

/* augment wave 1 allowances up to similar proportion
of earnings as in subsequent waves */
wage93=wagebt;
earn=earn*1.07;
earn93=earn;

wagecp=wage93;
earncp=earn93;
wagecpm=wage93;
earncpm=earn93;

wage93us=wage93/405.27;
earn93us=earn93/405.27;
pcallow=(earn93-wage93)/earn93;

proc means; run;
proc sort; by firm wave wid;


data worker2; set cd.merge12;

wid21=wid1;
wid22=wid2;
wid2=wid;
drop wid1;

wage94=wagebt;
earn94=earn;

/* annual CPI figures */
wagecp=wage94*196.4/261.4;
earncp=earn94*196.4/261.4;

/* monthly CPI figures*/
wagecpm=wage94*198.8/268.9;
earncpm=earn94*198.8/268.9;

wage94us=wage94/509.63;
earn94us=earn94/509.63;

proc means; run;
proc sort; by firm wave wid;

data worker3; set cd.merge23;

wid32=wid2;
wid33=wid3;
wid3=wid;
drop wid2;

wage95=wagebt;
earn95=earn;

/* annual CPI figures */
wagecp=wage95*196.4/361.6;
earncp=earn95*196.4/361.6;

/* monthly CPI figures*/
wagecpm=wage95*198.8/382.9;
earncpm=earn95*198.8/382.9;

wage95us=wage95/577.37;
earn95us=earn95/577.37;

proc means; run;
proc sort; by firm wave wid;


data cd.cd.work123; merge worker1 worker2 worker3; by firm wave;

if wave=1 then wave1=1; else wave1=0;
if wave=2 then wave2=1; else wave2=0;
if wave=3 then wave3=1; else wave3=0;

if sex=1 then male=1; else male=0;
if sex=2 then female=1; else female=0;

/*education categories*/

if educ=4 and edform=8 then educ=8;

if educ=0 then none=1; else none=0;
if educ>0 and educ<7 then primnc=1; else primnc=0;
if primnc=0 and edlevela=2 or edlevela=3 or edlevelb=7
then primc=1; else primc=0;
if edlevela=4 or edlevela=5 or edlevelb=8 or edlevelb=9
then second=1; else second=0;
if educ>=16 then univ=1; else univ=0;


if primc=1 or primnc=1 then primary=1; else primary=0;

if none=1 then eddum='anone';
if primnc=1 then eddum='bprnc';
if primc=1 then eddum='cprco';
if second=1 then eddum='dsecd';
if univ=1 then eddum='euniv';

if none=1 or primnc=1 then eddum2='aprinc';
if primc=1 then eddum2='bprim';
if second=1 then eddum2='csecd';
if univ=1 then eddum2='duniv';

years=agesch-6;

/* occupational skills categories */
if mgmt=1 or admin=1 then white=1; else white=0;
if cleric=1 or sales=1 then pink=1; else pink=0;
if super=1 or tech=1 or prod=1 then blue=1; else blue=0;

if white=1 then coldum='white';
if pink=1 then coldum='pink';
if blue=1 then coldum='blue';

if mgmt=1 or admin=1 or sales=1 or super=1 then skill=1; else skill=0;
if cleric=1 or tech=1 or prod=1 then unskill=1; else unskill=0;

if skill=1 then skdum='skill';
if unskill=1 then skdum='unskill';

/*
if wave=3;
proc print; var firm wid educ tenure age workexp; run;
*/

proc means; run;

/* BRING IN FIRM LEVEL CHARACTERISTICS TO BE INCLUDED 
IN EARNINGS FUNCTIONS BELOW */


data temp5; set cd.owners;
if union=2 then union=0;
if union92=2 then union92=0;

proc sort; by firm;
proc means; run;

data temp6; merge cd.size3 cd.size2 cd.size1; by firm;

proc means; run;
proc sort; by firm;

data all123; merge cd.cd.work123 temp5 temp6; by firm;
proc means; run;


/* EARNINGS FUNCTIONS */

data earnfc1; set cd.cd.work123;

agesq=age*age;
expsq=tenure*tenure;
educsq=educ*educ;

lwage=log(earn);

proc reg; model lwage= male age agesq educ educsq tenure expsq
mgmt admin sales cleric super tech wave2 wave3; run;

data earnfc2; set cd.work123;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earn);

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech wave2 wave3; run;


data earnfc3; set cd.work123;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earn);

proc reg; model learn= male age agesq educ tenure
expsq wave2 wave3; run;

/* RETURNS TO EDUCATION BY LEVELS */

data earnfc4; set cd.work123;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earn);

proc reg; model learn= male age agesq primc second univ tenure
expsq mgmt admin
sales cleric super tech wave2 wave3; run;

/* MALE FEMALE BREAKDOWN */

data male123; set cd.work123;

if male=0 then delete;

agesq=age*age;
expsq=tenure*tenure;

lmearn=log(earn);

proc reg; model lmearn= age agesq primc second univ tenure
expsq mgmt admin
sales cleric super tech wave2 wave3; run;


data fem123; set cd.work123;

if male=1 then delete;

agesq=age*age;
expsq=tenure*tenure;

lfearn=log(earn);

proc reg; model lfearn= age agesq primc second univ tenure
expsq mgmt admin
sales cleric super tech wave2 wave3; run;

/* RETURNS TO EXPERIENCE */

data earnfc4; set cd.work123;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earncpm);

if primary=1;
if age>23 and age<45;

proc reg; model learn= male age agesq tenure
expsq mgmt admin
sales cleric super tech wave2 wave3; run;


data earnfc4; set cd.work123;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earncpm);

if second=1;
if age>24 and age<46;

proc reg; model learn= male age agesq tenure
expsq mgmt admin
sales cleric super tech wave2 wave3; run;


data earnfc4; set cd.work123;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earncpm);

if univ=1;
if age>39 and age<51;

proc reg; model learn= male age agesq tenure
expsq mgmt admin
sales cleric wave2 wave3; run;



/* CONSTANT PRICE EARNINGS FUNCS - CHANGES IN REAL WAGES
WITH INTERACTION TERMS */


data efunc1; set male123;

agesq=age*age;
expsq=tenure*tenure;

skill1=skill*wave1;
skill2=skill*wave2;
skill3=skill*wave3;

learn=log(earncpm);

proc reg; model learn=age agesq primc second univ tenure
expsq skill skill2 skill3 wave2 wave3; run;


data efunc2; set fem123;

agesq=age*age;
expsq=tenure*tenure;

skill1=skill*wave1;
skill2=skill*wave2;
skill3=skill*wave3;

learn=log(earncpm);

proc reg; model learn=age agesq primc second univ tenure
expsq skill skill2 skill3 wave2 wave3; run;


data efunc3; set all123;

/* if micro=1 then delete;

if earncpm>150000 then delete;
if earncpm<5000 then delete; */

agesq=age*age;
expsq=tenure*tenure;

skill2=skill*wave2;
skill3=skill*wave3;

learn=log(earncpm);
lemp=log(emp);

/* if micro=1 or small=1; */
 if medium=1 or large=1;



proc reg; model learn= age agesq primc second univ tenure
expsq skill
skill2 skill3 wave2 wave3; run;

proc univariate; var earncpm; run;


/* CROSS TABS ON POOLED DATA */
/* ALL WORKERS */
data checks1; set cd.work123;

proc means; var firm wid educ years age wagecpm earncpmm; run;

proc sort; by ocdum wave;
proc means; var firm wid educ age wagecpm earncpm; by ocdum wave; run;

proc sort; by wave skdum;
proc means; var firm wid educ years age wagecpm earncpm; by wave skdum; run;

proc sort; by wave coldum;
proc means; var firm wid educ years age wagecpm earncpm; by wave coldum; run;

proc sort; by eddum;
proc means; var firm wid educ years age wagecpm earncpm; by eddum; run;

proc sort; by eddum2;
proc means; var firm wid educ years age wagecpm earncpm; by eddum2; run;


/* MALE WORKERS */
data checks2; set male123;

proc means; var firm wid educ years age wagecpm earncpmm; run;

proc sort; by ocdum wave;
proc means; var firm wid educ age wagecpm earncpm; by ocdum wave; run;

proc sort; by wave skdum;
proc means; var firm wid educ years age wagecpm earncpm; by wave skdum; run;

proc sort; by wave coldum;
proc means; var firm wid educ years age wagecpm earncpm; by wave coldum; run;

proc sort; by eddum;
proc means; var firm wid educ years age wagecpm earncpm; by eddum; run;

proc sort; by eddum2;
proc means; var firm wid educ years age wagecpm earncpm; by eddum2; run;

/* FEMALE WORKERS */
data checks3; set fem123;

proc means; run;

proc means; var firm wid educ years age wagecpm earncpm; run;

proc sort; by ocdum wave;
proc means; var firm wid educ age wagecpm earncpm; by ocdum wave; run;

proc sort; by wave skdum;
proc means; var firm wid educ years age wagecpm earncpm; by wave skdum; run;

proc sort; by wave coldum;
proc means; var firm wid educ years age wagecpm earncpm; by wave coldum; run;

proc sort; by eddum;
proc means; var firm wid educ years age wagecpm earncpm; by eddum; run;

proc sort; by eddum2;
proc means; var firm wid educ years age wagecpm earncpm; by eddum2; run;


/* ANALYSIS including firm characteristics */

data checks2; set all123;

/* if emp>5 and emp<16 then sizedum='amsmall';
if emp>1000 then sizedum='evlarge'; */

if skill=1 then skearn=earncpm;
if skill=0 then unskearn=earncpm;


proc sort; by sizedum wave;
proc print; var firm wid educ emp skearn unskearn earncpm; by sizedum wave; run;


proc sort; by ocdum;
proc means; var firm wid educ emp wagecpm earncpm; by ocdum; run;

proc sort; by indlab;
proc means; var firm wid educ emp wagecpm earncpm; by indlab; run;

proc sort; by sectlab;
proc means; var firm wid educ emp wagecpm earncpm; by sectlab; run;


data temp; set cd.genfirm;

keep firm vad;
proc sort; by firm;


data earnfcX; merge all123 temp; by firm;

agesq=age*age;
expsq=tenure*tenure;

vademp=vad/emp;

learn=log(earncpm);
lemp=log(emp);
lvad=log(vademp);

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech lemp lvad wave2 wave3;
run;





proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech state sstate sfor anyfor tzown lemp
 wave2 wave3;
run;

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech asian african mideast other wave2 wave3;
run;

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech food text wood wave2 wave3;
run;
